# 데브옵스(DevOps)
Development + Operations의 합성어  
소프트웨어 개발자와 정보기술 전문가 간의 소통, 협업 및 통합을 강조하는 개발 환경이나 문화를 의미한다.

>DevOps는 애플리케이션과 서비스를 빠른 속도로 제공할 수 있도록 조직의 역량을 향상시키는 문화 철학, 방식 및 도구의 조합입니다. 기존의 소프트웨어 개발 및 인프라 관리 프로세스를 사용하는 조직보다 제품을 더 빠르게 혁신하고 개선할 수 있습니다. 이러한 빠른 속도를 통해 조직은 고객을 더 잘 지원하고 시장에서 좀 더 효과적으로 경쟁할 수 있습니다.(출처: AWS)

목적 : 소프트웨어 제품과 서비스를 빠른 시간에 개발 및 배포하는 것
소프트웨어 제품이나 서비스를 알맞은 시기에 출시하기 위해 개발과 운영이 상호 의존적으로 대응해야 한다는 의미로 많이 사용하고 있다.

데브옵스의 개념은 애자일 기법과 지속적 통합의 개념과도 관련이 있다.

- [애자일 기법]  
실질적인 코딩을 기반으로 일정한 주기에 따라 지속적으로 프로토타입을 형성하고, 필요한 요구사항을 파악하며 이에 따라 즉시 수정사항을 적용하여 결과적으로 하나의 큰 소프트웨어를 개발하는 적응형 개발 방법

- [지속적 통합]  
통합 작업을 초기부터 계속 수행해서 지속적으로 소프트웨어의 품질 제어를 적용하는 것

### **DevOps의 특징**  
**Cross Functional Team**  
하나의 팀에 개발 부터 운영까지 모두 할 수 있는 사람들로 채우라는뜻이 아니라, 각 프로세스의(개발 ~ 배포 및 테스트까지) 담당자들을 하나의 팀으로 모으라는 뜻이다. 서비스 기획부터 개발 운영 테스트 배포등 모든 제품 개발 프로세스를 하나의 팀에서 할 수 있도록 해야 한다는것이 Cross Functional Team이다.

**Widely Shared Metrics**  
한마디로, 팀원 모두가 알고있는 하나의 공유된 지표가 필요하다는것이다.
서비스를 개발만 하는게 아니라 서비스가 운영에서 잘 돌아가고 있는지, 사용자의 반응은 어떤지를 측정할 수 있는 기준이 필요하다는것이다. 그리고 이 지표를 기준으로 팀원들이 아 우리 서비스가 이정도로 잘돌아가고있구나, 아니면 아 이부분은 좀 부족하구나라는걸 인지할 수 있도록 해야한다.

**Automating repetitive tasks**  
반복적인 일들은 자동화 하라는것이다. CI/CD를 이용해서 빌드-배포-테스트 프로세스를 자동화 해야한다. 반복작업에 투입되는 시간을 줄여야 좀 더 생산적으로 일할수 있고 좀 더 고도화된 서비스를 만들 여유와 시간을 벌 수 있을것이다. 고급인력들을 데려다 놓고 반복작업에 시간을 쏟게 하는것은 개인적으로나 회사 전체로보나 손해이다. 그리고 자동화 툴을 만드는 과정에서 시스템 전체에 대한 이해가 높아진다. 여러모로 장점이 많다.

**Post Mortems**  
직역하자면 후처리라고 할 수 있다. 장애나 이슈가 있을때 그걸 혼자만 알지 말고 팀원들과 공유를 해야한다. 서비스를 운영만 하다보면 어떤 이슈가 있을때 이 이슈가 얼마나 큰 이슈인지를 파악하지 못할떄가 많다.

**Regular Release**  
짧은 주기의 정기 배포를 통해서 빠르게 서비스의 기능을 개선하고 고객들의 VoC를 반영해 나가야한다.

### **DevOps 장점**(출처: AWS)
- **속도**   
작업 속도가 빨라지므로 고객을 위해 더 빠르게 혁신하고, 시장 변화에 더 잘 적응하고, 좀 더 효율적으로 비즈니스 성과를 창출할 수 있습니다. DevOps 모델을 사용하면 개발자와 운영팀이 이러한 성과를 실현할 수 있습니다.
- **신속한 제공**    
릴리스의 빈도와 속도를 개선하여 제품을 더 빠르게 혁신하고 개선할 수 있습니다. 새로운 기능의 릴리스와 버그 수정 속도가 빨라질수록 고객의 요구에 더 빠르게 대응하여 경쟁 우위를 강화할 수 있습니다.
- **안정성**   
최종 사용자에게 지속적으로 긍정적인 경험을 제공하는 한편 더욱 빠르게 안정적으로 제공할 수 있도록 애플리케이션 업데이트와 인프라 변경의 품질을 보장합니다.
- **확장 가능**   
규모에 따라 인프라와 개발 프로세스를 운영 및 관리합니다. 자동화와 일관성이 지원되므로 위험을 줄이면서 복잡한 시스템 또는 변화하는 시스템을 효율적으로 관리할 수 있습니다.
- **협업 강화**   
주인의식 및 책임과 같은 가치를 강조하는 DevOps 문화 모델에서 좀 더 효과적인 팀을 구축합니다. 개발자와 운영팀은 긴밀하게 협력하고, 많은 책임을 공유하며, 워크플로를 결합합니다. 이를 통해 비효율성을 줄이고 시간을 절약합니다
- **보안**      
제어를 유지하고 규정을 준수하면서 신속하게 진행할 수 있습니다. 자동화된 규정 준수 정책, 세분화된 제어 및 구성 관리 기술을 사용함으로써 보안을 그대로 유지하면서 DevOps 모델을 도입할 수 있습니다. 